/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen.layer;

import com.yungnickyoung.minecraft.bettercaves.BetterCavesCommon;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseUtils;
import com.yungnickyoung.minecraft.bettercaves.worldgen.BetterCavesWorldCarverConfig;
import com.yungnickyoung.minecraft.bettercaves.worldgen.carver.AbstractCarver;
import com.yungnickyoung.minecraft.bettercaves.worldgen.carver.CarverNoiseRange;
import com.yungnickyoung.minecraft.bettercaves.worldgen.carver.CavernCarver;
import com.yungnickyoung.minecraft.yungsapi.math.ColPos;
import com.yungnickyoung.minecraft.yungsapi.noise.FastNoise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_6350;
import net.minecraft.class_6643;
import net.minecraft.class_6880;

public class CavernLayer {
    private final FastNoise cavernRegionSampler;
    private final List<CarverNoiseRange> noiseRanges = new ArrayList<CarverNoiseRange>();
    private final BetterCavesWorldCarverConfig config;
    private final boolean isDebugViewEnabled;
    private final boolean isOverrideSurfaceDetectionEnabled;

    public CavernLayer(class_3218 serverLevel, BetterCavesWorldCarverConfig config, BetterCavesWorldCarverConfig.CavernLayerSettings layerSettings) {
        this.config = config;
        this.isDebugViewEnabled = config.debugSettings.enabled();
        this.isOverrideSurfaceDetectionEnabled = config.misc.overrideSurfaceDetection();
        double cavernRegionSize = layerSettings.cavernRegionSizeFrequency();
        this.cavernRegionSampler = new FastNoise();
        this.cavernRegionSampler.SetSeed((int)serverLevel.method_8412() + 333);
        this.cavernRegionSampler.SetFrequency((float)cavernRegionSize);
        List<AbstractCarver> carvers = CavernCarver.createCarversFromConfig(serverLevel, config, layerSettings);
        float spawnChance = (float)(layerSettings.cavernSpawnChance() / 100.0);
        int totalSpawnWeight = carvers.stream().map(AbstractCarver::getSpawnWeight).reduce(0, Integer::sum);
        BetterCavesCommon.LOGGER.debug("CAVERN INFORMATION");
        BetterCavesCommon.LOGGER.debug("--> SPAWN CHANCE SET TO: {}", (Object)Float.valueOf(spawnChance));
        BetterCavesCommon.LOGGER.debug("--> TOTAL SPAWN WEIGHT: {}", (Object)totalSpawnWeight);
        carvers.removeIf(carver -> carver.getSpawnWeight() == 0);
        float totalDeadzonePercent = 1.0f - spawnChance;
        float deadzonePercent = carvers.size() > 1 ? totalDeadzonePercent / (float)(carvers.size() - 1) : totalDeadzonePercent;
        BetterCavesCommon.LOGGER.debug("--> DEADZONE PERCENT: {}({} TOTAL)", (Object)Float.valueOf(deadzonePercent), (Object)Float.valueOf(totalDeadzonePercent));
        float currNoise = -1.0f;
        for (AbstractCarver carver2 : carvers) {
            BetterCavesCommon.LOGGER.debug("--> CARVER");
            float rangeCDFPercent = (float)carver2.getSpawnWeight() / (float)totalSpawnWeight * spawnChance;
            float topNoise = NoiseUtils.simplexNoiseOffsetByPercent(currNoise, rangeCDFPercent);
            CarverNoiseRange range = new CarverNoiseRange(currNoise, topNoise, carver2);
            this.noiseRanges.add(range);
            currNoise = NoiseUtils.simplexNoiseOffsetByPercent(topNoise, deadzonePercent);
            BetterCavesCommon.LOGGER.debug("    --> RANGE PERCENT LENGTH WANTED: {}", (Object)Float.valueOf(rangeCDFPercent));
            BetterCavesCommon.LOGGER.debug("    --> RANGE FOUND: {}", (Object)range);
        }
    }

    public void carveChunk(class_2791 chunkAccess, int[][] surfaceAltitudes, class_2680[][] liquidBlocks, Function<class_2338, class_6880<class_1959>> biomeProvider, class_6643 carvingMask, class_6350 aquifer) {
        if (this.noiseRanges.isEmpty()) {
            return;
        }
        for (int subX = 0; subX < 4; ++subX) {
            for (int subZ = 0; subZ < 4; ++subZ) {
                int localSubStartX = subX * 4;
                int localSubStartZ = subZ * 4;
                int localSubEndX = localSubStartX + 4 - 1;
                int localSubEndZ = localSubStartZ + 4 - 1;
                class_2338 startPos = new class_2338(chunkAccess.method_12004().field_9181 * 16 + localSubStartX, 1, chunkAccess.method_12004().field_9180 * 16 + localSubStartZ);
                class_2338 endPos = new class_2338(chunkAccess.method_12004().field_9181 * 16 + localSubEndX, 1, chunkAccess.method_12004().field_9180 * 16 + localSubEndZ);
                int maxHeight = Integer.MIN_VALUE;
                if (!this.isOverrideSurfaceDetectionEnabled) {
                    for (int x = localSubStartX; x <= localSubEndX; ++x) {
                        for (int z = localSubStartZ; z <= localSubEndZ; ++z) {
                            maxHeight = Math.max(maxHeight, surfaceAltitudes[x][z]);
                        }
                    }
                    for (CarverNoiseRange range : this.noiseRanges) {
                        maxHeight = Math.max(maxHeight, range.getCarver().getTopY());
                    }
                } else {
                    for (CarverNoiseRange range : this.noiseRanges) {
                        maxHeight = Math.max(maxHeight, range.getCarver().getTopY());
                    }
                }
                HashMap<CarverNoiseRange, double[][][][]> noiseCubes = new HashMap<CarverNoiseRange, double[][][][]>();
                for (CarverNoiseRange range : this.noiseRanges) {
                    double[][][][] noiseCube = range.getCarver().getNoiseGen().interpolateNoiseCube(startPos, endPos, range.getCarver().getBottomY(), maxHeight);
                    noiseCubes.put(range, noiseCube);
                }
                for (int offsetX = 0; offsetX < 4; ++offsetX) {
                    block8: for (int offsetZ = 0; offsetZ < 4; ++offsetZ) {
                        int localX = localSubStartX + offsetX;
                        int localZ = localSubStartZ + offsetZ;
                        ColPos colPos = new ColPos(chunkAccess.method_12004().field_9181 * 16 + localX, chunkAccess.method_12004().field_9180 * 16 + localZ);
                        int surfaceAltitude = surfaceAltitudes[localX][localZ];
                        class_2680 liquidBlock = liquidBlocks[localX][localZ];
                        float cavernRegionNoise = this.cavernRegionSampler.GetNoise((float)colPos.getX(), (float)colPos.getZ());
                        for (CarverNoiseRange range : this.noiseRanges) {
                            if (!range.contains(cavernRegionNoise)) continue;
                            int topY = this.isDebugViewEnabled || this.isOverrideSurfaceDetectionEnabled ? range.getCarver().getTopY() : Math.min(surfaceAltitude, range.getCarver().getTopY());
                            float smoothAmp = range.getSmoothAmp(cavernRegionNoise);
                            double[][] noiseColumn = ((double[][][][])noiseCubes.get(range))[offsetX][offsetZ];
                            ((CavernCarver)range.getCarver()).carveColumn(this.config, chunkAccess, colPos, topY, smoothAmp, noiseColumn, liquidBlock, carvingMask, aquifer);
                            continue block8;
                        }
                    }
                }
            }
        }
    }
}

